#encoding utf-8

__author__ = "Roland Trouville"
__copyright__ = "Copyright 2021+, LPP"
__license__ = "Creative Commons 4.0 By-Nc-Sa"
__maintainer__ = "Roland Trouville"
__email__ = "roland.trouville@sorbonne-nouvelle.fr"
__status__ = "Production"

import os
import moviepy as mp
from tools.data_manager import DataManager

class FileManager(object):

	@staticmethod
	def list_all_files(extension:list, path:str)->list:
		ret = []
		if os.path.isdir(path):
			dir = os.listdir(path)
			for file in dir:
				flow = file.lower()
				for e in extension:
					if flow.endswith(e):
						ret.append(path+file)
		return ret

	@staticmethod
	def list_all_inputs():
		ret = []
		inputdirpath = "./input/"
		if os.path.isdir( inputdirpath):
			dirs = os.listdir(inputdirpath)
			for file in dirs:
				if os.path.isdir(inputdirpath+file):
					ret.append(file)
		return ret

	@staticmethod
	def check_input_dir(path:str):
		files = FileManager.list_all_files([".mov",".mp4",".avi"], path)
		print(files)
		if len(files) != 1:
			raise Exception("No video file or more than one video file found in "+path)
		videof = files[0]
		audiof = path+"audio/clip.wav"
		if not os.path.isfile(audiof):
			if not os.path.isdir(path+"audio/"):
				os.mkdir(path+"audio/")
			videoclip = mp.VideoFileClip(videof)
			try:
				videoclip.audio.write_audiofile(audiof)
			except AttributeError:
				DataManager.log("Video has no audio")
				audiof = None
			videoclip.close()
		framesdir = path+"frames/"
		if not os.path.isdir(framesdir):
			os.mkdir(framesdir)
		datadir = path+"data/"
		if not os.path.isdir(datadir):
			os.mkdir(datadir)
		datadir = path + "export/"
		if not os.path.isdir(datadir):
			os.mkdir(datadir)



		return (videof, audiof)
